﻿using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    /// <summary>
    /// Summary description for BprDoDDeploymentFactoryTests
    /// </summary>
    [TestClass]
    public class BprDoDDeploymenConcreteFactoryTests : DeploymentFactoryTestBase
    {
       
        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>


        #region Additional test attributes
        //
        // You can use the following additional attributes as you write your tests:
        //
        // Use ClassInitialize to run code before running the first test in the class
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // Use ClassCleanup to run code after all tests in a class have run
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // Use TestInitialize to run code before running each test 
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // Use TestCleanup to run code after each test has run
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        [TestMethod()]
        public void CreateDeployments_Should_Continue_To_Process_Deployments_If_There_Is_A_Null_Deployment_Location()
        {
            string sutEdipi = "1068619536";
            Dictionary<DateRange, string> svcDateRange = CreateSvcDateRange();
            Deployment[] deployments = new Deployment[2];
            Deployment depOne = new Deployment
            {
                edipi = sutEdipi,
                deploymentData = new DeploymentData
                {
                    DeploymentLocation = CreateTwoDeploymentLocations(),
                    deploymentStartDate = DateTime.Parse("2005-11-01"),
                    deploymentEndDate = DateTime.Parse("2006-11-29")
                }
            };
            deployments[0] = depOne;
            Deployment deploymentWithNoLocations = new Deployment
            {
                edipi = sutEdipi,
                deploymentData = new DeploymentData
                {
                    DeploymentLocation = null,
                    deploymentProjectCode = "9GF",
                    deploymentSegmentIdentifier = "1",
                    deploymentTerminationReason = "S"
                }
            };
            deployments[1] = deploymentWithNoLocations;

            eMISdeploymentResponseType response = new eMISdeploymentResponseType
            {
                deployment = deployments
            };
           // MilitaryOccupationHistoryManager mohMgr = new MilitaryOccupationHistoryManager(sqlConnection);
            BprDoDDeploymentFactory factory = new BprDoDDeploymentFactory(sqlConnection);
            List<IDeployment> actual = factory.CreateDeployments(response, svcDateRange);
            Assert.IsNotNull(actual);
            Assert.AreEqual(2, actual.Count);

        }

        [TestMethod]
        public void CreateDeployments_Throws_ArgumentNullException_When_Given_No_Deployments()
        {
            
            Dictionary<DateRange, string> svcDateRange = CreateSvcDateRange();
            Deployment[] deployments = new Deployment[1];
           
            deployments[0] = null;

            eMISdeploymentResponseType response = new eMISdeploymentResponseType
            {
                deployment = deployments
            };
            //MilitaryOccupationHistoryManager mohMgr = new MilitaryOccupationHistoryManager(sqlConnection);
            BprDoDDeploymentFactory factory = new BprDoDDeploymentFactory(sqlConnection);
            AssertException.Throws<ArgumentNullException>(() => factory.CreateDeployments(response, svcDateRange));
        }

    }
}
